#ifndef CPPCADES_CP_PRIVATEKEY_OBJECT_H_
#define CPPCADES_CP_PRIVATEKEY_OBJECT_H_

#include "cppcades.h"
#include "CPPCadesCPOID.h"
#include "CPPCadesCPEncodedData.h"

namespace CryptoPro {
namespace PKI {
namespace CAdES {

class CPPCadesCPPrivateKeyObject
{
public:
    CPPCadesCPPrivateKeyObject(void);
    ~CPPCadesCPPrivateKeyObject(void);

    HRESULT get_ContainerName(CAtlString& value);
    HRESULT get_UniqueContainerName(CAtlString& value);
    HRESULT get_ProviderName(CAtlString& value);
    HRESULT get_ProviderType(CAPICOM_PROV_TYPE *pVal);
    HRESULT get_KeySpec(CAPICOM_KEY_SPEC *pVal);
    HRESULT get_IsDefaultPin(BOOL &pVal);
    HRESULT ChangePin();
    HRESULT Delete();
    HRESULT set_CachePin(BOOL bVal);
    HRESULT set_KeyPin(CAtlStringA& newVal);
    HRESULT get_CarrierFlags(unsigned int& pVal);
    HRESULT CacheKey(BOOL bVal);

    //internal use
    HRESULT put_KeyProvInfo(CCertContext& cert);

private:
    DISALLOW_COPY_AND_ASSIGN(CPPCadesCPPrivateKeyObject);
    HRESULT initCryptProv();

    ATL2::CCryptKeyProvInfo m_keyProvInfo;
    ATL2::CCryptProvEx m_cryptProv;

    CCertContext m_cert;
};
} /* namespace CAdES */
} /* namespace PKI */
} /* namespace CryptoPro */

#endif // CPPCADES_CP_PRIVATEKEY_OBJECT_H_

