#ifndef CPPCADES_CP_CHAIN_OBJECT_H_
#define CPPCADES_CP_CHAIN_OBJECT_H_

#include "cppcades.h"
#include "CPPCadesCollections.h"
#include "CPPCadesCPCertificate.h"

namespace CryptoPro {
namespace PKI {
namespace CAdES {

class CPPCadesCPChainObject
{
public:
    CPPCadesCPChainObject(void);
    ~CPPCadesCPChainObject(void);

    HRESULT get_Certificates(NS_SHARED_PTR::shared_ptr<CPPCadesCPCertificatesObject>& pVal);
    HRESULT get_Status(long Index, long *pVal);
    HRESULT Build(CPPCadesCPCertificateObject cert, BOOL *pVal);
    HRESULT CertificatePolicies(NS_SHARED_PTR::shared_ptr<CPPCadesCPOIDsObject>& pVal);
    HRESULT ApplicationPolicies(NS_SHARED_PTR::shared_ptr<CPPCadesCPOIDsObject>& pVal);
    HRESULT ExtendedErrorInfo(long Index, CAtlString *pVal);
    HRESULT get_ChainContext(PCCERT_CHAIN_CONTEXT* ppVal);
    HRESULT put_ChainContext(PCCERT_CHAIN_CONTEXT pVal);
    HRESULT FreeContext(PCCERT_CHAIN_CONTEXT pVal);

private:
    DISALLOW_COPY_AND_ASSIGN(CPPCadesCPChainObject);

#ifndef UNIX
#pragma warning(push)
#pragma warning(disable: 4251)
#endif
    ATL2::CCertChainContext m_chain;

    //      ,    -   
    NS_SHARED_PTR::shared_ptr<CPPCadesCPOIDsObject> m_pCertPolicies;
    NS_SHARED_PTR::shared_ptr<CPPCadesCPOIDsObject> m_pAppPolicies;
    NS_SHARED_PTR::shared_ptr<CPPCadesCPCertificatesObject> m_pCerts;
#ifndef UNIX
#pragma warning(pop)
#endif
};
} /* namespace CAdES */
} /* namespace PKI */
} /* namespace CryptoPro */

#endif // CPPCADES_CP_CHAIN_OBJECT_H_


