/*
 * Copyright(C) 2004-2006  
 *
 *    , 
 *    .
 *
 *        ,
 * ,    ,
 *     ,
 * ,      
 *     
 *      .
 */

/*!
 * \file $RCSfile$
 * \version $Revision: 289767 $
 * \date $Date:: 2025-04-03 17:41:04 +0300#$
 * \author $Author: een $
 *
 * \brief API    CAdES (CMS Advanced Electronic Signatures)
 */

#ifndef _CADES_H_INCLUDED
#define _CADES_H_INCLUDED
#include "ades-core.h"

#if defined(_MSC_VER) && (_MSC_VER >= 1400) && !defined(CADES_NOFORCE_MANIFEST)

#define CADES_ASSEMBLY_NAME "CryptoPro.PKI.CAdES"
#define CADES_ASSEMBLY_VERSION "2.0.0.0"

#ifndef CP_ASSEMBLY_PUBLICKEYTOKEN
#define CP_ASSEMBLY_PUBLICKEYTOKEN "a6d31b994cfcddc4"
#endif // CP_ASSEMBLY_PUBLICKEYTOKEN

#ifdef _M_IX86
#define CADES_ASSEMBLY_PROCARCH "x86"
#endif // _M_IX86

#ifdef _M_AMD64
#define CADES_ASSEMBLY_PROCARCH "amd64"
#endif // _M_AMD64

#pragma comment(linker,"/manifestdependency:\"type='win32' " \
        "name='" CADES_ASSEMBLY_NAME "' " \
        "version='" CADES_ASSEMBLY_VERSION "' " \
        "processorArchitecture='" CADES_ASSEMBLY_PROCARCH "' " \
        "language='*' " \
        "publicKeyToken='" CP_ASSEMBLY_PUBLICKEYTOKEN "'\"")

#endif // defined(_MSC_VER) && (_MSC_VER >= 1400) && !defined(CADES_NOFORCE_MANIFEST)

#if !defined CADES_DLL_DEFINES
#   define CADES_DLL_DEFINES
#   if defined _WIN32 && !defined CADES_STATIC
#	ifdef CADES_DLL
#	    define CADES_CLASS __declspec(dllexport)
#	    define CADES_API __declspec(dllexport)
#	    define CADES_DATA __declspec(dllexport)
#	    define CADES_EXTERN_TEMPLATE
#	else // defined CADES_DLL
#	    define CADES_CLASS __declspec(dllimport)
#	    define CADES_API __declspec(dllimport)
#	    define CADES_DATA __declspec(dllimport)
#	    define CADES_EXTERN_TEMPLATE extern
#	endif // !defined CADES_DLL
#   else // defined _WIN32 && !defined CADES_STATIC
#	define CADES_CLASS
#	define CADES_API
#	define CADES_DATA
#	define CADES_EXTERN_TEMPLATE
#       define NO_EXPIMP_CDLLLIST_ITERATORS
#   endif // !defined _WIN32 ||  defined CADES_STATIC
#endif // !defined CADES_DLL_DEFINES

//   LOWWORD
#define CADES_DEFAULT       0x00000000
#define CADES_BES           0x00000001
#define CADES_T             0x00000005
#define CADES_X_LONG_TYPE_1 0x0000005D
#define CADES_A             0x000000DD
#define PKCS7_TYPE          0x0000ffff

#define CADES_E_X_LONG      0x00000045

#define CADES_B_B           0x00000101
#define CADES_B_T           0x00000105
#define CADES_B_LT          0x00000745
#define CADES_B_LTA         0x000007C5

//     .
// HIWORD
#define CADES_DISABLE_REDUNDANCY          ADES_DISABLE_REDUNDANCY
#define CADES_USE_OCSP_AUTHORIZED_POLICY  ADES_USE_OCSP_AUTHORIZED_POLICY

#define CADES_AUTH_ANONYMOUS	0x00
#define CADES_AUTH_BASIC		0x01
#define CADES_AUTH_NTLM			0x02
#define CADES_AUTH_DIGEST		0x08
#define CADES_AUTH_NEGOTIATE	0x10

#define CADES_VERIFY_SUCCESS                        ADES_VERIFY_SUCCESS
#define CADES_VERIFY_INVALID_REFS_AND_VALUES        ADES_VERIFY_INVALID_REFS_AND_VALUES
#define CADES_VERIFY_SIGNER_NOT_FOUND               ADES_VERIFY_SIGNER_NOT_FOUND
#define CADES_VERIFY_NO_VALID_SIGNATURE_TIMESTAMP   ADES_VERIFY_NO_VALID_SIGNATURE_TIMESTAMP
#define CADES_VERIFY_REFS_AND_VALUES_NO_MATCH       ADES_VERIFY_REFS_AND_VALUES_NO_MATCH
#define CADES_VERIFY_NO_CHAIN                       ADES_VERIFY_NO_CHAIN
#define CADES_VERIFY_END_CERT_REVOCATION            ADES_VERIFY_END_CERT_REVOCATION
#define CADES_VERIFY_CHAIN_CERT_REVOCATION          ADES_VERIFY_CHAIN_CERT_REVOCATION
#define CADES_VERIFY_BAD_SIGNATURE                  ADES_VERIFY_BAD_SIGNATURE
#define CADES_VERIFY_NO_VALID_CADES_C_TIMESTAMP     ADES_VERIFY_NO_VALID_CADES_C_TIMESTAMP
#define CADES_VERIFY_BAD_POLICY                     ADES_VERIFY_BAD_POLICY
#define CADES_VERIFY_UNSUPPORTED_ATTRIBUTE          ADES_VERIFY_UNSUPPORTED_ATTRIBUTE
#define CADES_VERIFY_FAILED_POLICY                  ADES_VERIFY_FAILED_POLICY
#define CADES_VERIFY_ECONTENTTYPE_NO_MATCH          ADES_VERIFY_ECONTENTTYPE_NO_MATCH
#define CADES_VERIFY_NO_VALID_ARCHIVE_TIMESTAMP     ADES_VERIFY_NO_VALID_ARCHIVE_TIMESTAMP

#define CADES_TIMESTAMP_NO_CERT_REQ         ADES_TIMESTAMP_NO_CERT_REQ
#define CADES_CHECK_CERT_REQ                ADES_CHECK_CERT_REQ
#define CADES_SKIP_IE_PROXY_CONFIGURATION   ADES_SKIP_IE_PROXY_CONFIGURATION
#define CADES_LEGACY_CRL_RETRIEVE           ADES_LEGACY_CRL_RETRIEVE
#define CADES_CACHE_ONLY_URL_RETRIEVAL      ADES_CACHE_ONLY_URL_RETRIEVAL

#define CADES_ATS_ORDER_BY_DATE_ASC 0x00000001

// CADES-2312:     TSP-
#define CADES_ADDITIONAL_TSA_SEP L"::::"

typedef struct _CADES_AUTH_PARA
{
    DWORD dwSize;
    DWORD dwAuthType;
    LPCWSTR wszUsername;
    LPCWSTR wszPassword;
    PCCERT_CONTEXT pClientCertificate;
    DEFINE_ADES_STRUCT_MEMBERS(_CADES_AUTH_PARA)
} CADES_AUTH_PARA, *PCADES_AUTH_PARA;

typedef struct _CADES_SERVICE_CONNECTION_PARA
{
    DWORD dwSize;
    LPCWSTR wszUri;
    PCADES_AUTH_PARA pAuthPara;
    DEFINE_ADES_STRUCT_MEMBERS(_CADES_SERVICE_CONNECTION_PARA)
} CADES_SERVICE_CONNECTION_PARA, *PCADES_SERVICE_CONNECTION_PARA;

typedef struct _CADES_PROXY_PARA
{
    DWORD dwSize;
    LPCWSTR wszProxyUri;
    PCADES_AUTH_PARA pProxyAuthPara;
    DEFINE_ADES_STRUCT_MEMBERS(_CADES_PROXY_PARA)
} CADES_PROXY_PARA, *PCADES_PROXY_PARA;

typedef struct _CADES_SIGN_PARA
{
    DWORD dwSize;
    DWORD dwCadesType;
    PCCERT_CONTEXT pSignerCert;
    LPCSTR szHashAlgorithm;
    HCERTSTORE hAdditionalStore;
    PCADES_SERVICE_CONNECTION_PARA pTspConnectionPara;
    PCADES_PROXY_PARA pProxyPara;
    LPVOID pCadesExtraPara;
#ifdef CADES_PARA_HAS_EXTRA_FIELDS
    DWORD cAdditionalOCSPServices;
    LPCWSTR *rgAdditionalOCSPServices;
#endif //CADES_PARA_HAS_EXTRA_FIELDS
    DEFINE_ADES_STRUCT_MEMBERS(_CADES_SIGN_PARA)
} CADES_SIGN_PARA, *PCADES_SIGN_PARA;

typedef struct _CADES_EXTRA_PARA
{
    DWORD dwSize;
    DWORD dwFlags;
    DEFINE_ADES_STRUCT_MEMBERS(_CADES_EXTRA_PARA)
} CADES_EXTRA_PARA, *PCADES_EXTRA_PARA;

typedef struct _CADES_COSIGN_PARA
{
    DWORD dwSize;
    PCMSG_SIGNER_ENCODE_INFO pSigner;
    PCADES_SIGN_PARA pCadesSignPara;
    DEFINE_ADES_STRUCT_MEMBERS(_CADES_COSIGN_PARA)
} CADES_COSIGN_PARA, *PCADES_COSIGN_PARA;

typedef struct _CADES_ENCODE_INFO
{
    DWORD dwSize;
    PCMSG_SIGNED_ENCODE_INFO pSignedEncodeInfo;
    DWORD cSignerCerts;
    PCCERT_CONTEXT *rgSignerCerts;
    DWORD cHashAlgorithms;
    LPCSTR *rgHashAlgorithms;
    DEFINE_ADES_STRUCT_MEMBERS(_CADES_ENCODE_INFO)
} CADES_ENCODE_INFO, *PCADES_ENCODE_INFO;

typedef struct _CADES_SIGN_MESSAGE_PARA
{
    DWORD dwSize;
    PCRYPT_SIGN_MESSAGE_PARA pSignMessagePara;
    PCADES_SIGN_PARA pCadesSignPara;
    DEFINE_ADES_STRUCT_MEMBERS(_CADES_SIGN_MESSAGE_PARA)
} CADES_SIGN_MESSAGE_PARA, *PCADES_SIGN_MESSAGE_PARA;

typedef struct _CADES_VERIFICATION_PARA
{
    DWORD dwSize;
    LPVOID pMessageContentHash;
    PCADES_PROXY_PARA pProxyPara;
    HCERTSTORE hStore;
    BOOL bReserved2;
    LPVOID pReserved3;
    DWORD dwCadesType;
#ifdef CADES_PARA_HAS_EXTRA_FIELDS
    DWORD dwFlags;
#endif //CADES_PARA_HAS_EXTRA_FIELDS
    DEFINE_ADES_STRUCT_MEMBERS(_CADES_VERIFICATION_PARA)
} CADES_VERIFICATION_PARA, *PCADES_VERIFICATION_PARA;

typedef struct _CADES_VERIFICATION_INFO
{
    DWORD dwSize;
    DWORD dwStatus;
    PCCERT_CONTEXT pSignerCert;
    LPFILETIME pSigningTime;
    LPFILETIME pReserved;
    LPFILETIME pSignatureTimeStampTime;
#ifdef CADES_PARA_HAS_EXTRA_TIME_FIELDS
    LPFILETIME pEarliestCadesCTimeStampTime;
    LPFILETIME pEarliestArchiveTimeStampTime;
    LPFILETIME pLatestArchiveTimeStampTime; //   
#endif
    DEFINE_ADES_STRUCT_MEMBERS(_CADES_VERIFICATION_INFO)
} CADES_VERIFICATION_INFO, *PCADES_VERIFICATION_INFO;

typedef struct _CADES_VERIFY_MESSAGE_PARA
{
    DWORD dwSize;
    PCRYPT_VERIFY_MESSAGE_PARA pVerifyMessagePara;
    PCADES_VERIFICATION_PARA pCadesVerifyPara;
    DEFINE_ADES_STRUCT_MEMBERS(_CADES_VERIFY_MESSAGE_PARA)
} CADES_VERIFY_MESSAGE_PARA, *PCADES_VERIFY_MESSAGE_PARA;

typedef struct _CADES_ENHANCE_MESSAGE_PARA
{
    DWORD dwSize;
    DWORD dwMsgEncodingType;
    PCADES_SIGN_PARA pCadesSignPara;
    DEFINE_ADES_STRUCT_MEMBERS(_CADES_ENHANCE_MESSAGE_PARA)
} CADES_ENHANCE_MESSAGE_PARA, *PCADES_ENHANCE_MESSAGE_PARA;

typedef struct _CADES_VIEW_SIGNATURE_PARA
{
    DWORD dwSize;
    DWORD dwMsgEncodingType;
    HCRYPTPROV hCryptProv;
    DEFINE_ADES_STRUCT_MEMBERS(_CADES_VIEW_SIGNATURE_PARA)
} CADES_VIEW_SIGNATURE_PARA, *PCADES_VIEW_SIGNATURE_PARA;

typedef void* PCADES_CONVERT_CONTEXT;

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus

// Low-level API
CADES_API HCRYPTMSG WINAPI CadesMsgOpenToEncode(  
    DWORD dwMsgEncodingType,
    DWORD dwFlags,
    PCADES_ENCODE_INFO pvMsgEncodeInfo,
    __in_opt LPSTR pszInnerContentObjID,
    PCMSG_STREAM_INFO pStreamInfo);

CADES_API BOOL WINAPI CadesMsgIsType(
    HCRYPTMSG hCryptMsg,
    DWORD dwSignatureIndex,
    DWORD dwCadesType,
    BOOL *pbResult);

CADES_API BOOL WINAPI CadesMsgIsTypeEncoded(
    DWORD dwEncodingType,
    PBYTE pbSignerInfo,
    DWORD cbSignerInfo,
    DWORD dwCadesType,
    BOOL *pbResult);

CADES_API BOOL WINAPI CadesMsgEnhanceSignature(
    HCRYPTMSG hCryptMsg,
    DWORD dwSignatureIndex,
    __in_opt PCADES_SIGN_PARA pCadesSignPara);

CADES_API BOOL WINAPI CadesMsgEnhanceSignatureAll(
    HCRYPTMSG hCryptMsg,
    __in_opt PCADES_SIGN_PARA pCadesSignPara);
/*   testCadesMsgCreateSignature_CADES_T_FutureCRL  coverparams.
CADES_API BOOL WINAPI CadesMsgEnhanceSignatureTimeStamp(HCRYPTMSG,
	PCCERT_CONTEXT, LPCSTR, VOID*, VOID*);
*/
CADES_API BOOL WINAPI CadesMsgAddEnhancedSignature(
    HCRYPTMSG hCryptMsg,
    PCADES_COSIGN_PARA pCadesCosignPara);

CADES_API BOOL WINAPI CadesMsgVerifySignature(
    HCRYPTMSG hCryptMsg,
    DWORD dwSignatureIndex,
    __in_opt PCADES_VERIFICATION_PARA pVerificationPara,
    __out_opt PCADES_VERIFICATION_INFO *ppVerificationInfo);

CADES_API BOOL WINAPI CadesMsgCountersignEncoded(
    DWORD dwEncodingType,
    PBYTE pbSignerInfo,
    DWORD cbSignerInfo,
    DWORD cCountersigners,
    PCADES_COSIGN_PARA rgCountersigners,
    PCRYPT_DATA_BLOB *ppCountersignature);

CADES_API BOOL WINAPI CadesMsgCountersign(
    HCRYPTMSG hCryptMsg,
    DWORD dwIndex,
    DWORD cCountersigners,
    PCADES_COSIGN_PARA rgCountersigners);

CADES_API BOOL WINAPI CadesMsgVerifyCountersignatureEncoded(
    HCRYPTPROV hCryptProv,
    DWORD dwEncodingType,
    PBYTE pbSignerInfo,
    DWORD cbSignerInfo,
    PBYTE pbSignerInfoCountersignature,
    DWORD cbSignerInfoCountersignature,
    PCERT_INFO pciCountersigner,
    __in_opt PCADES_VERIFICATION_PARA pVerificationPara,
    __out_opt PCADES_VERIFICATION_INFO *ppVerificationInfo);

CADES_API BOOL WINAPI CadesMsgVerifyCountersignatureEncodedEx(
    HCRYPTPROV hCryptProv,
    DWORD dwEncodingType,
    PBYTE pbSignerInfo,
    DWORD cbSignerInfo,
    PBYTE pbSignerInfoCountersignature,
    DWORD cbSignerInfoCountersignature,
    DWORD dwSignerType,
    void * pvSigner,
    DWORD dwFlags,
    void * pvReserved,
    __in_opt PCADES_VERIFICATION_PARA pVerificationPara,
    __out_opt PCADES_VERIFICATION_INFO *ppVerificationInfo);

CADES_API BOOL WINAPI CadesMsgGetSigningCertId(
    HCRYPTMSG hCryptMsg,
    DWORD dwSignatureIndex,
    PCRYPT_DATA_BLOB *ppCertId);

CADES_API BOOL WINAPI CadesMsgGetSigningCertIdEx(
    PCMSG_SIGNER_INFO pSignerInfo,
    PCRYPT_DATA_BLOB *ppCertId);

CADES_API BOOL WINAPI CadesMsgGetSigningCertIdEncoded(
    DWORD dwEncodingType,
    PBYTE pbSignerInfo,
    DWORD cbSignerInfo,
    PCRYPT_DATA_BLOB *ppCertId);

CADES_API ALG_ID WINAPI CadesMsgGetSigningCertIdHashAlg(
    HCRYPTMSG hCryptMsg,
    DWORD dwSignatureIndex);

CADES_API BOOL WINAPI CadesMsgGetSignatureTimestamps( 
    HCRYPTMSG hCryptMsg,
    DWORD dwSignatureIndex,
    PCADES_BLOB_ARRAY *ppTimestamps);

CADES_API BOOL WINAPI CadesMsgGetCadesCTimestamps( 
    HCRYPTMSG hCryptMsg,
    DWORD dwSignatureIndex,
    PCADES_BLOB_ARRAY *ppTimestamps);

CADES_API BOOL WINAPI CadesMsgGetArchiveTimestamps(
    HCRYPTMSG hCryptMsg,
    DWORD dwSignatureIndex,
    DWORD dwFlags,
    void * pvReserved,
    PCADES_BLOB_ARRAY *ppTimestamps);

CADES_API BOOL WINAPI CadesMsgGetCertificateValues(
    HCRYPTMSG hCryptMsg,
    DWORD dwSignatureIndex,
    PCADES_BLOB_ARRAY *ppCertificates);

CADES_API BOOL WINAPI CadesMsgGetRevocationValues(
    HCRYPTMSG hCryptMsg,
    DWORD dwSignatureIndex,
    PCADES_BLOB_ARRAY *ppCRLs,
    PCADES_BLOB_ARRAY *ppBasicOCSPResponses);

CADES_API ALG_ID WINAPI CadesMsgGetSigningCertIdHashAlgEx(
    PCMSG_SIGNER_INFO pSignerInfo);

CADES_API BOOL WINAPI CadesMsgGetSignatureTimestampsEx( 
    PCMSG_SIGNER_INFO pSignerInfo,
    PCADES_BLOB_ARRAY *ppTimestamps);

CADES_API BOOL WINAPI CadesMsgGetCadesCTimestampsEx( 
    PCMSG_SIGNER_INFO pSignerInfo,
    PCADES_BLOB_ARRAY *ppTimestamps);

CADES_API BOOL WINAPI CadesMsgGetArchiveTimestampsEx(
    PCMSG_SIGNER_INFO pSignerInfo,
    DWORD dwFlags,
    void * pvReserved,
    PCADES_BLOB_ARRAY *ppTimestamps);

CADES_API BOOL WINAPI CadesMsgGetCertificateValuesEx(
    PCMSG_SIGNER_INFO pSignerInfo,
    PCADES_BLOB_ARRAY *ppCertificates);

CADES_API BOOL WINAPI CadesMsgGetRevocationValuesEx(
    PCMSG_SIGNER_INFO pSignerInfo,
    PCADES_BLOB_ARRAY *ppCRLs,
    PCADES_BLOB_ARRAY *ppBasicOCSPResponses);

CADES_API BOOL WINAPI CadesMsgGetSignatureTimestampsEncoded( 
    DWORD dwEncodingType,
    PBYTE pbSignerInfo,
    DWORD cbSignerInfo,
    PCADES_BLOB_ARRAY *ppTimestamps);

CADES_API BOOL WINAPI CadesMsgGetCadesCTimestampsEncoded( 
    DWORD dwEncodingType,
    PBYTE pbSignerInfo,
    DWORD cbSignerInfo,
    PCADES_BLOB_ARRAY *ppTimestamps);

CADES_API BOOL WINAPI CadesMsgGetArchiveTimestampsEncoded(
    DWORD dwEncodingType,
    PBYTE pbSignerInfo,
    DWORD cbSignerInfo,
    DWORD dwFlags,
    void * pvReserved,
    PCADES_BLOB_ARRAY *ppTimestamps);

CADES_API BOOL WINAPI CadesMsgGetCertificateValuesEncoded(
    DWORD dwEncodingType,
    PBYTE pbSignerInfo,
    DWORD cbSignerInfo,
    PCADES_BLOB_ARRAY *ppCertificates);

CADES_API BOOL WINAPI CadesMsgGetRevocationValuesEncoded(
    DWORD dwEncodingType,
    PBYTE pbSignerInfo,
    DWORD cbSignerInfo,
    PCADES_BLOB_ARRAY *ppCRLs,
    PCADES_BLOB_ARRAY *ppBasicOCSPResponses);

CADES_API ALG_ID WINAPI CadesMsgGetSigningCertIdHashAlgEncoded(
    DWORD dwEncodingType,
    PBYTE pbSignerInfo,
    DWORD cbSignerInfo);

// User Interface API
#if defined _WIN32
CADES_API BOOL WINAPI CadesMsgUIDisplaySignature(
    HCRYPTMSG hCryptMsg,
    DWORD dwSignatureIndex,
    __in_opt HWND hwndParent,
    __in_opt LPCWSTR title);

CADES_API BOOL WINAPI CadesMsgUIDisplaySignatureByHash(
    HCRYPTMSG hCryptMsg,
    DWORD dwSignatureIndex,
    __in_opt HWND hwndParent,
    __in_opt LPCWSTR title,
    __in_opt const BYTE* pbHashBlob,
    __in_opt DWORD cbHashBlob,
    __in_opt PCRYPT_ALGORITHM_IDENTIFIER pHashAlgorithm);

CADES_API BOOL WINAPI CadesMsgUIDisplaySignatures(
    HCRYPTMSG hCryptMsg,
    __in_opt HWND hwndParent,
    __in_opt LPCWSTR title);

CADES_API BOOL WINAPI CadesMsgUIDisplaySignaturesByHash(
    HCRYPTMSG hCryptMsg,
    __in_opt HWND hwndParent,
    __in_opt LPCWSTR title,
    __in_opt const BYTE* pbHashBlob,
    __in_opt DWORD cbHashBlob,
    __in_opt PCRYPT_ALGORITHM_IDENTIFIER pHashAlgorithm);

CADES_API BOOL WINAPI CadesMsgViewSignature(
    HCRYPTMSG hCryptMsg,
    DWORD dwSignatureIndex,
    LPCPROPSHEETPAGE **prgPropPages,
    DWORD *pcPropPages);

CADES_API BOOL WINAPI CadesMsgViewSignatures(
    HCRYPTMSG hCryptMsg,
    LPCPROPSHEETPAGE **prgPropPages,
    DWORD *pcPropPages);

CADES_API BOOL WINAPI CadesViewSignature(
    PCADES_VIEW_SIGNATURE_PARA pCadesViewSignaturePara,
    DWORD dwSignatureIndex,
    const BYTE *pbSignedBlob,
    DWORD cbSignedBlob,
    LPCPROPSHEETPAGE **prgPropPages,
    DWORD *pcPropPages);

CADES_API BOOL WINAPI CadesViewSignatureDetached(
    PCADES_VIEW_SIGNATURE_PARA pCadesViewSignaturePara,
    DWORD dwSignatureIndex,
    const BYTE *pbDetachedSignBlob,
    DWORD cbDetachedSignBlob,
    DWORD cToBeSigned,
    const BYTE *rgpbToBeSigned[],
    DWORD rgcbToBeSigned[],
    LPCPROPSHEETPAGE **prgPropPages,
    DWORD *pcPropPages);

CADES_API BOOL WINAPI CadesViewSignatures(
    PCADES_VIEW_SIGNATURE_PARA pCadesViewSignaturePara,
    const BYTE *pbSignedBlob,
    DWORD cbSignedBlob,
    LPCPROPSHEETPAGE **prgPropPages,
    DWORD *pcPropPages);

CADES_API BOOL WINAPI CadesViewSignaturesDetached(
    PCADES_VIEW_SIGNATURE_PARA pCadesViewSignaturePara,
    const BYTE *pbDetachedSignBlob,
    DWORD cbDetachedSignBlob,
    DWORD cToBeSigned,
    const BYTE *rgpbToBeSigned[],
    DWORD rgcbToBeSigned[],
    LPCPROPSHEETPAGE **prgPropPages,
    DWORD *pcPropPages);

CADES_API BOOL WINAPI CadesUIDisplaySignature(
    PCADES_VIEW_SIGNATURE_PARA pCadesViewSignaturePara,
    DWORD dwSignatureIndex,
    const BYTE *pbSignedBlob,
    DWORD cbSignedBlob,
    __in_opt HWND hwndParent,
    __in_opt LPCWSTR title);

CADES_API BOOL WINAPI CadesUIDisplaySignatures(
    PCADES_VIEW_SIGNATURE_PARA pCadesViewSignaturePara,
    const BYTE *pbSignedBlob,
    DWORD cbSignedBlob,
    __in_opt HWND hwndParent,
    __in_opt LPCWSTR title);

CADES_API BOOL WINAPI CadesUIDisplaySignatureDetached(
    PCADES_VIEW_SIGNATURE_PARA pCadesViewSignaturePara,
    DWORD dwSignatureIndex,
    const BYTE *pbDetachedSignBlob,
    DWORD cbDetachedSignBlob,
    DWORD cToBeSigned,
    const BYTE *rgpbToBeSigned[],
    DWORD rgcbToBeSigned[],
    __in_opt HWND hwndParent,
    __in_opt LPCWSTR title);

CADES_API BOOL WINAPI CadesUIDisplaySignaturesDetached(
    PCADES_VIEW_SIGNATURE_PARA pCadesViewSignaturePara,
    const BYTE *pbDetachedSignBlob,
    DWORD cbDetachedSignBlob,
    DWORD cToBeSigned,
    const BYTE *rgpbToBeSigned[],
    DWORD rgcbToBeSigned[],
    __in_opt HWND hwndParent,
    __in_opt LPCWSTR title);

CADES_API BOOL WINAPI CadesFreeSignaturePropPages(
    LPCPROPSHEETPAGE *prgPropPages,
    DWORD pcPropPages);

#endif // _WIN32

// Simplified API

CADES_API BOOL WINAPI CadesSignMessage(
    PCADES_SIGN_MESSAGE_PARA pSignPara,
    BOOL fDetachedSignature,
    DWORD cToBeSigned,
    const BYTE* rgpbToBeSigned[],
    DWORD rgcbToBeSigned[],
    PCRYPT_DATA_BLOB *ppSignedBlob);

CADES_API BOOL WINAPI CadesSignHash(
    PCADES_SIGN_MESSAGE_PARA pSignPara,
    const BYTE* pbHash,
    DWORD cbHash,
    __in_opt LPCSTR pszInnerContentObjID,
    PCRYPT_DATA_BLOB *ppSignedBlob);

CADES_API BOOL WINAPI CadesVerifyHash(
    PCADES_VERIFY_MESSAGE_PARA pVerifyPara,
    DWORD dwSignerIndex,
    const BYTE* pbDetachedSignBlob,
    DWORD cbDetachedSignBlob,
    const BYTE* pbHash,
    DWORD cbHash,
    PCRYPT_ALGORITHM_IDENTIFIER pHashAlgorithm,
    __out_opt PCADES_VERIFICATION_INFO *ppVerificationInfo);

CADES_API BOOL WINAPI CadesAddHashSignature(
    PCADES_SIGN_MESSAGE_PARA pSignPara,
    const BYTE* pbDetachedSignBlob,
    DWORD cbDetachedSignBlob,
    const BYTE* pbHash,
    DWORD cbHash,
    PCRYPT_DATA_BLOB *ppSignedBlob);

CADES_API BOOL WINAPI CadesVerifyMessage(
    PCADES_VERIFY_MESSAGE_PARA pVerifyPara,
    DWORD dwSignerIndex,
    const BYTE* pbSignedBlob,
    DWORD cbSignedBlob,
    __out_opt PCRYPT_DATA_BLOB* ppDecodedBlob,
    __out_opt PCADES_VERIFICATION_INFO *ppVerificationInfo);

CADES_API BOOL WINAPI CadesVerifyDetachedMessage(
    PCADES_VERIFY_MESSAGE_PARA pVerifyPara,
    DWORD dwSignerIndex,
    const BYTE* pbDetachedSignBlob,
    DWORD cbDetachedSignBlob,
    DWORD cToBeSigned,
    const BYTE* rgpbToBeSigned[],
    DWORD rgcbToBeSigned[],
    __out_opt PCADES_VERIFICATION_INFO *ppVerificationInfo);

CADES_API BOOL WINAPI CadesEnhanceMessage(
    PCADES_ENHANCE_MESSAGE_PARA pEnhancePara,
    DWORD dwSignerIndex,
    const BYTE* pbSignedBlob,
    DWORD cbSignedBlob,
    PCRYPT_DATA_BLOB* ppEnhancedBlob);

CADES_API BOOL WINAPI CadesEnhanceMessageAll(
    PCADES_ENHANCE_MESSAGE_PARA pEnhancePara,
    const BYTE* pbSignedBlob,
    DWORD cbSignedBlob,
    PCRYPT_DATA_BLOB* ppEnhancedBlob);

// Utility API

CADES_API BOOL WINAPI CadesFreeVerificationInfo(
    PCADES_VERIFICATION_INFO pVerificationInfo);

CADES_API BOOL WINAPI CadesFreeBlob(
    PCRYPT_DATA_BLOB pBlob);

CADES_API BOOL WINAPI CadesFreeBlobArray(
    PCADES_BLOB_ARRAY pBlobArray);

CADES_API DWORD WINAPI CadesFormatMessage(
    DWORD dwFlags,
    __in_opt LPCVOID lpSource,
    DWORD dwMessageId,
    DWORD dwLanguageId,
    LPTSTR lpBuffer,
    DWORD nSize,
    __in_opt va_list* Arguments);

// Convert API

CADES_API PCADES_CONVERT_CONTEXT WINAPI CadesMsgConvertCreateContext( 
    PCMSG_STREAM_INFO pStreamInfo,
    PBYTE pbDetachedMessage,
    DWORD cbDetachedMessage);

CADES_API BOOL WINAPI CadesMsgConvertUpdate(
    PCADES_CONVERT_CONTEXT pConvertContext,
    const BYTE* pbData,
    DWORD cbData,
    BOOL fFinal);

CADES_API BOOL WINAPI CadesMsgConvertFreeContext( 
    PCADES_CONVERT_CONTEXT pConvertContext);

#ifdef __cplusplus 
} /* extern "C" */
#endif // __cplusplus

#endif // _CADES_H_INCLUDED
